Option Explicit

' Script Constants, Strings
Const scriptName = "Reveal Overflowed Text"
Const scriptVer = "1.0.3"

' Revision History

' 1.0.3 - MJM - Fixed a problem with the constants.  Sped things up a bit.
' 1.0.2 - MJM - Fixed the error message that comes up when there are no text flows, due to a bug in the app.
' 1.0.1 - MJM - Added a message that shows when there are no more overflowed text flows.


' Script constants, questions, and error messages.
Const errRequirements = "This script requires an open document."
Const msgNoOverflows = "There are no overflowed text flows in this document."
Const msgShowNextFlow = "Show next overflowed text block?"

Dim msgRestart
msgRestart = "There are no more overflowed text blocks in this document." & vbCrlf & vbCrlf & "Show first overflowed text block?"




' Main

Dim errNum
errNum = 0

Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

If CreatorApp.Documents.Count = 0 Then
  Call MsgBox(errRequirements, vbOkonly, scriptName)
  errNum = -1
End If

Dim flows, flowCount, showNextFlow, aFlow
If errNum = 0 Then
  On Error Resume Next
  Set flows = CreatorApp.ActiveDocument.TextFlows
  errNum = Err.Number
  If (errNum = 0) Then
    flowCount = flows.Count
    errNum = Err.Number
  End If
  On Error GoTo 0
  
  If (errNum <> 0) Then
    Call MsgBox(msgNoOverflows, vbOkonly, scriptName)
  Elseif (flowCount = 0) Then
    Call MsgBox(msgNoOverflows, vbOKOnly, scriptName)
    errNum = -1
  Else
    showNextFlow = CreatorApp.ActiveDocument.HasOverflowedText
    
    If (Not showNextFlow) Then
      Call MsgBox(msgNoOverflows, vbOKOnly, scriptName)
      errNum = -1
    End If
    
  End If
  
End If

If errNum = 0 Then
  Do While showNextFlow
    For Each aFlow In flows
      If aFlow.HasOverflowedText Then
        aFlow.TextBlocks(-1).Reveal
        showNextFlow = (MsgBox(msgShowNextFlow, vbYesNo, scriptName) = vbYes)
      End If
      
      If (Not showNextFlow) Then Exit For
    Next
    
    If (showNextFlow) Then
      showNextFlow = (MsgBox(msgRestart, vbYesno, scriptName) = vbYes)
    End If
  Loop
End If

